//--------------------------------------------------------------------
// FILENAME:			scandisp.h
//
// Copyright(c) 1999-2002 Symbol Technologies Inc. All rights reserved.
//
// DESCRIPTION:			Contains window display functions for the main 
//						application windows.
//
// NOTES:				
//
//--------------------------------------------------------------------

#ifdef __cplusplus
extern "C" {
#endif

extern HANDLE      g_hImage;
extern HPALETTE    g_hPalette;  // not used in this application


void DisplayDIBSection (HDC hdc, HANDLE hImage, int picturesize, int topx, int topy, int bottomx, int bottomy);

HANDLE CreateDIBSectionFromRawBits( int RawImageColor, unsigned RawImageWidth, unsigned RawImageHeight, 
											  unsigned RawImageBitsPerPixel, BYTE *RawImageRaw, HWND hWnd );

HANDLE CreateDIBSectionFromDIBFile( unsigned long length, 
											   BYTE *RawImageRaw, HWND hWnd );
HANDLE CreateDIBSectionFromTIFFFile( unsigned long l, 
											   BYTE *w, HWND hWnd );

HPALETTE GetPaletteHandle(HWND hwnd, HANDLE hImage);


#ifdef __cplusplus
}
#endif
